//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module ERROR.H
//
//-----------------------------------------------------------------------------------

#ifndef _ERROR_H_
#define _ERROR_H_


///////////////////////////////////////////////////////////////
// Includes
//
///////////////////////////////////////////////////////////////
#include "common.h"


///////////////////////////////////////////////////////////////
// Defines
//
///////////////////////////////////////////////////////////////
typedef struct _NAMEMAP
{
	LONG		lItem;		// Item
	CHAR*		pszName;	// Name
} NAMEMAP;

typedef struct _WIDENAMEMAP
{
	LONG		lItem;		// Item
	WCHAR*		pwszName;	// Name
} WIDENAMEMAP;


typedef struct _GUIDMAP
{
	const GUID*		pGuid;		// Guid
	CHAR*			pszName;	// Name
} GUIDMAP;


////////////////////////////////////////////////////////////////////////////
// Extened Error Info
//
////////////////////////////////////////////////////////////////////////////
enum ERRORPOST
{
	EP_ERRORINFO_ALWAYS		= 0x00000002,
	EP_ERRORINFO_FAILURE	= 0x00000004,
	EP_ERRORINFO_NEVER		= 0x00000008,

	EP_HRESULT_ALWAYS		= 0x00000010,
	EP_HRESULT_NOERRORINFO	= 0x00000020,
	EP_HRESULT_NEVER		= 0x00000040,
	EP_HRESULT_FAILURE		= 0x00000080,

	EP_REFCOUNT_FAILURE		= 0x00000100,
};

extern DWORD g_dwErrorPost;
BOOL SetErrorPosting(ERRORPOST eErrorPost, BOOL fSet = TRUE);
BOOL GetErrorPosting(ERRORPOST eErrorPost);


CHAR* GetMapName(GUID guid, ULONG cGuidMap, const GUIDMAP* rgGuidMap);
CHAR* GetMapName(LONG lItem, ULONG cNameMap, const NAMEMAP* rgNameMap);
LONG GetMapName(CHAR* psz, ULONG cNameMap, const NAMEMAP* rgNameMap);
WCHAR* GetMapName(LONG lItem, ULONG cNameMap, const WIDENAMEMAP* rgNameMap);
LONG GetMapName(WCHAR* pwsz, ULONG cNameMap, const WIDENAMEMAP* rgNameMap);

WCHAR* GetErrorName(HRESULT hr);
CHAR* GetPropSetName(GUID guidPropertySet);
CHAR* GetPropertyName(DBPROPID dwPropertyID, GUID guidPropertySet);
CHAR* GetStatusName(DBSTATUS dwStatus);
DBSTATUS GetStatusValue(CHAR* pszName);
CHAR* GetInterfaceName(REFIID riid);

//Get IErrorRecords
HRESULT DisplayAllErrors(HWND hWnd, HRESULT hrActual, WCHAR* pwszFile = L"Unknown", ULONG ulLine = 0);
HRESULT DisplayAllErrors(HWND hWnd, HRESULT hrActual, HRESULT hrExpected, WCHAR* pwszFile = L"Unknown", ULONG ulLine = 0);
HRESULT DisplayAllErrorInfo(HWND hWnd, WCHAR* pwszFile = L"Unknown", ULONG ulLine = 0);
HRESULT DisplayHRESULT(HWND hWnd, HRESULT hrActual, WCHAR* pwszFile = L"Unknown", ULONG ulLine = 0);
HRESULT DisplayErrorRecords(HWND hWnd, ULONG cRecords, IErrorRecords* pIErrorRecords, WCHAR* pwszFile = L"Unknown", ULONG ulLine = 0);
HRESULT GetErrorRecords(HWND hWnd, ULONG* pcRecords, IErrorRecords** ppIErrorRecords);

//Get ISQLErrorInfo
HRESULT GetSqlErrorInfo(ULONG iRecord, IErrorRecords* pIErrorRecords, BSTR* pBstr, LONG* plNativeError = NULL);

//Property Errors
HRESULT DisplayPropErrors(HWND hWnd, SOURCE ePropSource, IUnknown* pIUnknown);
HRESULT DisplayPropErrors(HWND hWnd, ULONG cPropSets, DBPROPSET* rgPropSets);

//Binding Errors
HRESULT DisplayBindingErrors(HWND hWnd, ULONG cBindings, DBBINDING* rgBindings, void* pData);
HRESULT DisplayRowErrors(HWND hWnd, ULONG cRows, HROW* rghRows, DBROWSTATUS* rgRowStatus);
HRESULT DisplayAccessorErrors(HWND hWnd, ULONG cBindings, DBBINDING* rgBindings, DBBINDSTATUS* rgStatus);

//RefCount Errors
HRESULT DisplayRefCountErrors(HWND hWnd, CHAR* pszName, ULONG ulActRefCount, ULONG ulExpRefCount = 0);

#endif	//_ERROR_H_
